/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

/*
 *  MDIO Header file
 *
 */
#ifndef _DM814x_MDIO_H_
#define _DM814x_MDIO_H_
#ifdef __cplusplus
 extern "C" {
#endif

#include "DM814x_EVM.h"

/* ------------------------------------------------------------------------ *
 *  MDIO Controller                                                         *
 * ------------------------------------------------------------------------ */
#define MDIO_BASE               0x4A100800
#define MDIO_CONTROL            *( volatile UINT32* )( MDIO_BASE + 0x04 )
#define MDIO_ALIVE              *( volatile UINT32* )( MDIO_BASE + 0x08 )
#define MDIO_LINK               *( volatile UINT32* )( MDIO_BASE + 0x0c )
#define MDIO_LINKINTRAW         *( volatile UINT32* )( MDIO_BASE + 0x10 )
#define MDIO_LINKINTMASKED      *( volatile UINT32* )( MDIO_BASE + 0x14 )
#define MDIO_USERINTRAW         *( volatile UINT32* )( MDIO_BASE + 0x20 )
#define MDIO_USERINTMASKED      *( volatile UINT32* )( MDIO_BASE + 0x24 )
#define MDIO_USERINTMASKSET     *( volatile UINT32* )( MDIO_BASE + 0x28 )
#define MDIO_USERINTMASKCLEAR   *( volatile UINT32* )( MDIO_BASE + 0x2c )
#define MDIO_USERACCESS0        *( volatile UINT32* )( MDIO_BASE + 0x80 )
#define MDIO_USERPHYSEL0        *( volatile UINT32* )( MDIO_BASE + 0x84 )
#define MDIO_USERACCESS1        *( volatile UINT32* )( MDIO_BASE + 0x88 )
#define MDIO_USERPHYSEL1        *( volatile UINT32* )( MDIO_BASE + 0x8c )

#define GMII_SEL				*( volatile UINT32* )(0x48140650)

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM814x_MDIO_H_ */
